
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1216.C - Message 1216 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1216 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1216.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:00   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:48:52   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:38   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:59:20   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:10   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"  

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1216 message from the ZMsgBuf.
//
void Dec1216(tMSGBUF *ZMsgBuf, tMSG1216 *Msg)
{
   GetBit    (&ColdStartData.Disable      , ZMsgBuf, 7, 0); // 1=disable
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1216 message in the ZMsgBuf. 
//
void Bld1216(tMSGBUF *ZMsgBuf, tMSG1216 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                           , ZMsgBuf, 1);    // message preamble
   PutShort  (1216                             , ZMsgBuf, 2);    // message number
   PutShort  (3                                , ZMsgBuf, 3);    // message length 
   PutShort  (ANREQ                            , ZMsgBuf, 4);    // message ack/nack request
   
   PutBit    (ColdStartData.Disable       , ZMsgBuf, 7, 0); // 1=disable
}